package org.beast.data.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.bson.types.ObjectId;

import java.io.IOException;

public class MongoModule extends SimpleModule {

    public MongoModule() {
        super(Version.unknownVersion());
        this.addSerializer(ObjectId.class, new ToStringSerializer(ObjectId.class));
        this.addDeserializer(ObjectId.class, new FromStringDeserializer<>(ObjectId.class) {

            @Override
            protected ObjectId _deserialize(String value, DeserializationContext ctxt) throws IOException {
                return new ObjectId(value);
            }
        });
    }
}
