package org.beast.data.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.beast.data.jackson.ser.MessageErrorSerializer;
import org.beast.data.message.ErrorMessageSource;
import org.beast.data.message.MessageError;

/**
 * 错误消息
 */
public class ErrorModule extends SimpleModule {
    public ErrorModule(ErrorMessageSource errorMessageSource) {
        super(Version.unknownVersion());
        this.addSerializer(MessageError.class, new MessageErrorSerializer(errorMessageSource));
    }
}
