/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.beast.data.jackson.ErrorModule;
import org.beast.data.jackson.MoneyModule;
import org.beast.data.jackson.MongoModule;
import org.beast.data.jackson.ser.PageSerializer;
import org.beast.data.message.ErrorMessageAutoConfiguration;
import org.beast.data.message.ErrorMessageSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ObjectMapper.class})
@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
@AutoConfigureAfter(value={ErrorMessageAutoConfiguration.class})
public class JacksonCustomAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class})
    static class JacksonCustomizerConfiguration {
        JacksonCustomizerConfiguration() {
        }

        @Order(value=1)
        @Bean
        public Jackson2ObjectMapperBuilderCustomizer defaultJackson2ObjectMapperBuilderCustomizer() {
            return jacksonObjectMapperBuilder -> {
                jacksonObjectMapperBuilder.serializationInclusion(JsonInclude.Include.NON_NULL);
                jacksonObjectMapperBuilder.featuresToEnable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
                jacksonObjectMapperBuilder.featuresToDisable(new Object[]{SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS});
                jacksonObjectMapperBuilder.featuresToDisable(new Object[]{DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS});
                jacksonObjectMapperBuilder.serializerByType(Long.class, (JsonSerializer)ToStringSerializer.instance);
                jacksonObjectMapperBuilder.serializerByType(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            };
        }

        @Order(value=1)
        @ConditionalOnClass(value={Page.class})
        @Bean
        public Jackson2ObjectMapperBuilderCustomizer defaultPageJackson2ObjectMapperBuilderCustomizer() {
            return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.serializers(new JsonSerializer[]{new PageSerializer()});
        }

        @Bean
        @ConditionalOnBean(value={ErrorMessageSource.class})
        public ErrorModule errorModule(ErrorMessageSource source) {
            return new ErrorModule(source);
        }

        @Bean
        @ConditionalOnClass(value={MongoOperations.class})
        public MongoModule mongoModule() {
            return new MongoModule();
        }

        @Bean
        public MoneyModule moneyModule() {
            return new MoneyModule();
        }
    }
}

