/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.jackson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.beast.data.domain.SimpleMoney;

public class SimpleMoneySerializer
extends StdScalarSerializer<SimpleMoney> {
    public SimpleMoneySerializer() {
        super(SimpleMoney.class);
    }

    public void serialize(SimpleMoney money, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeNumber(money.getBigDecimal());
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("number", true);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitFloatFormat(visitor, typeHint, JsonParser.NumberType.FLOAT);
    }
}

