/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.jackson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import org.beast.data.message.ErrorInfo;
import org.beast.data.message.ErrorMessageSource;
import org.beast.data.message.IError;
import org.beast.data.message.MessageError;

public class MessageErrorSerializer
extends StdScalarSerializer<MessageError> {
    private ErrorMessageSource errorMessageSource;

    public MessageErrorSerializer(ErrorMessageSource errorMessageSource) {
        super(MessageError.class);
        this.errorMessageSource = errorMessageSource;
    }

    public void serialize(MessageError value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String errorCode = value.getCode();
        String message = this.errorMessageSource.getMessage((IError)value);
        gen.writeObject((Object)new ErrorInfo(errorCode, message));
    }
}

