package org.beast.data.field.value;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import org.beast.data.field.Field;
import org.beast.data.field.ObjectField;
import org.beast.data.field.ResolveField;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 需要实现的
 */
public class FieldValueConverter {

    private ValueResolver resolver = new ValueResolver() {
        @Override
        public Object resolve(Object value) {
            return null;
        }
    };
//    private EDUQuestionValueResolver eduQuestionValueResolver;
//    private TestProductValueResolver testProductValueResolver;

//    public FieldValueConverter(EDUQuestionValueResolver eduQuestionValueResolver, TestProductValueResolver testProductValueResolver) {
//        this.eduQuestionValueResolver = eduQuestionValueResolver;
//        this.testProductValueResolver = testProductValueResolver;
//    }
    //    private GameValueResolver resolver;

//    public FieldValueConverter(GameValueResolver resolver) {
//        this.resolver = resolver;
//    }

    public Object apply(Field field, Object value) {
        return applyField(field, value);
    }

    private Object applyField(Field field, Object value) {
        //            case ARRAY:
        //                return applyArray()
        return switch (field.getType()) {
            case RESOLVE -> applyValueResolve((ResolveField) field, value);
            case OBJECT -> applyObject((ObjectField) field, value);
            default -> value;
        };
    }
    private Map<String, Object> applyObject(ObjectField field, Object value) {
        if (value == null) {
            return null;
        }
        Map<String, Object> objectValue = (Map<String, Object>) value;
        Map<String, Object> output = Maps.newHashMap();
        List<ObjectField.ObjectFieldItem> items = field.getFields();
        for (ObjectField.ObjectFieldItem item : items) {
            String itemKey = item.getKey();
            Field itemField = item.getField();
            Object itemValue = objectValue.get(itemKey);
            itemValue = applyField(itemField, itemValue);

            output.put(itemKey, itemValue);
        }
        return output;
    }

    private Object applyValueResolve(ResolveField field, Object value) {
        if (value == null) {
            return Maps.newHashMap();
        }
        if (!(value instanceof Map<?, ?>)) {
            return Maps.newHashMap();
        }
        String resolverName = field.getResolverName();
        //对expression处理接收数据
        Map<String, Object> resolveValue = (Map<String, Object>) value;
        String input = (String) resolveValue.get("input");
        if (Strings.isNullOrEmpty(input)) {
            return resolveValue;
        }
        Object resolved = null;
//        if (Objects.equals(resolverName, "ask-question")) {
//            resolved = eduQuestionValueResolver.resolve(input);
//        }
//        if (Objects.equals(resolverName, "test-product")) {
//            resolved = testProductValueResolver.resolve(input);
//        }
        resolveValue.put("resolved", resolved);
        return resolveValue;
    }
}
