package org.beast.data.field;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Getter;
import lombok.Setter;

@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = NoneField.class, name = "NONE"),
        @JsonSubTypes.Type(value = ObjectField.class, name = "OBJECT"),
        @JsonSubTypes.Type(value = ArrayField.class, name = "ARRAY"),
        @JsonSubTypes.Type(value = StringField.class, name = "STRING"),
        @JsonSubTypes.Type(value = MediaField.class, name = "MEDIA"),
        @JsonSubTypes.Type(value = ResolveField.class, name = "RESOLVE"),
})
@Getter @Setter
public abstract class Field {

    private FieldType type;

    private String label;

    public Field(FieldType type) {
        this.type = type;
    }
}
