/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.field.value;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beast.data.field.Field;
import org.beast.data.field.FieldType;
import org.beast.data.field.ObjectField;
import org.beast.data.field.ResolveField;
import org.beast.data.field.value.ValueResolver;

public class FieldValueConverter {
    private ValueResolver resolver = new ValueResolver(){

        public Object resolve(Object value) {
            return null;
        }
    };

    public Object apply(Field field, Object value) {
        return this.applyField(field, value);
    }

    private Object applyField(Field field, Object value) {
        return switch (field.getType()) {
            case FieldType.RESOLVE -> this.applyValueResolve((ResolveField)field, value);
            case FieldType.OBJECT -> this.applyObject((ObjectField)field, value);
            default -> value;
        };
    }

    private Map<String, Object> applyObject(ObjectField field, Object value) {
        if (value == null) {
            return null;
        }
        Map objectValue = (Map)value;
        HashMap output = Maps.newHashMap();
        List<ObjectField.ObjectFieldItem> items = field.getFields();
        for (ObjectField.ObjectFieldItem item : items) {
            String itemKey = item.getKey();
            Field itemField = item.getField();
            Object itemValue = objectValue.get(itemKey);
            itemValue = this.applyField(itemField, itemValue);
            output.put(itemKey, itemValue);
        }
        return output;
    }

    private Object applyValueResolve(ResolveField field, Object value) {
        if (value == null) {
            return Maps.newHashMap();
        }
        if (!(value instanceof Map)) {
            return Maps.newHashMap();
        }
        String resolverName = field.getResolverName();
        Map resolveValue = (Map)value;
        String input = (String)resolveValue.get("input");
        if (Strings.isNullOrEmpty((String)input)) {
            return resolveValue;
        }
        Object resolved = null;
        resolveValue.put("resolved", resolved);
        return resolveValue;
    }
}

