package org.beast.data.ua;

import java.util.regex.Pattern;

public enum ClientAgent {

    //MiniProgramEnv/android
    WEAPP(Pattern.compile(".*\\bminiProgram.*", Pattern.CASE_INSENSITIVE)),
    WECHAT_DEVTOOLS(Pattern.compile(".*\\bwechatdevtools\\b.*", Pattern.CASE_INSENSITIVE)),

    BYTEAPP(Pattern.compile(".*\\btoutiaomicroapp\\b.*", Pattern.CASE_INSENSITIVE)),

    WEB(Pattern.compile(".*web.*", Pattern.CASE_INSENSITIVE)),

    UNKNOWN(Pattern.compile(".*"))
    ;

    final Pattern pattern;

    ClientAgent(Pattern pattern) {
        this.pattern = pattern;
    }

    public static ClientAgent valueOfString(String string) {
        try {
            return ClientAgent.valueOf(string);
        } catch (Exception ignore) {}
        return UNKNOWN;
    }

    public static ClientAgent parseUserAgent(String userAgent) {
        if (WECHAT_DEVTOOLS.pattern.matcher(userAgent).matches()) {
            return WECHAT_DEVTOOLS;
        }
        if (WEAPP.pattern.matcher(userAgent).matches()) {
            return WEAPP;
        }
        if (BYTEAPP.pattern.matcher(userAgent).matches()) {
            return BYTEAPP;
        }
        if (WEB.pattern.matcher(userAgent).matches()) {
            return WEB;
        }
        return UNKNOWN;
    }
}
