package org.beast.data.relay;


import lombok.Data;

@Data
public class SimplePageInfo implements PageInfo {

    private Cursor startCursor;
    private Cursor endCursor;
    private Boolean hasPreviousPage;
    private Boolean hasNextPage;

    public SimplePageInfo() {
    }

    public SimplePageInfo(Cursor startCursor, Cursor endCursor, Boolean hasPreviousPage, Boolean hasNextPage) {
        this.startCursor = startCursor;
        this.endCursor = endCursor;
        this.hasPreviousPage = hasPreviousPage;
        this.hasNextPage = hasNextPage;
    }

    @Override
    public boolean isHasPreviousPage() {
        return hasPreviousPage;
    }

    @Override
    public boolean isHasNextPage() {
        return hasNextPage;
    }
}
