package org.beast.data.relay;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;
import java.util.function.Function;

@Data
public class SimpleConnection<T> implements Connection<T> {

    private List<Edge<T>> edges;

    private PageInfo pageInfo;

    private Long totalCount;

    public SimpleConnection() {
    }

    public SimpleConnection(@JsonProperty("edges") List<Edge<T>> edges,
                            @JsonProperty("pageInfo") PageInfo pageInfo,
                            @JsonProperty("totalCount") Long totalCount) {
        this.edges = edges;
        this.pageInfo = pageInfo;
        this.totalCount = totalCount;
    }


    @Override
    public <O> Connection<O> map(Function<T, O> mapper) {
        var output = this.edges.stream().map((edge) -> {
            return edge.map(mapper);
        }).toList();
        return new SimpleConnection<>(output, this.pageInfo, totalCount);
    }
}
