package org.beast.data.relay;


import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;

import java.util.Optional;

/**
 * first， last不同时支持？)
 * 基于光标分页
 * 基于offset分页   first-> limit  offset->offset
 * https://www.pdftron.com/blog/graphql/implementing-graphql-pagination/#offsetbased-pagination
 */
public class PageableRequest implements Pageable {


    private final Cursor after;

    private final Cursor before;

    private final Integer first;

    private final Integer last;

    private final Integer offset;

//    //颠倒
//    private final boolean reverse = false;
//
//    //排序字段(默认:升序)
//    private final String sortKey = null;
    private final Sort sort;

    private PageableRequest(Cursor after, Cursor before, Integer first, Integer last, Integer offset, Sort sort) {
        this.sort = sort;
        if (first != null && last != null) {
            throw new IllegalArgumentException("Passing both `first` and `last` to paginate connection is not supported.");
        }
        if (first != null && first < 0) {
            throw new IllegalArgumentException();
        }
        if (last != null && last < 0) {
            throw new IllegalArgumentException();
        }
//        if (offset != null && (after != null || before != null || last != null) ) {
//            throw new IllegalArgumentException("Passing both `offset` and `after, before, last` to paginate connection is not supported.");
//        }
        if (offset != null && last != null ) {
            throw new IllegalArgumentException("Passing both `offset` and `last` to paginate connection is not supported.");
        }
        this.after = after;
        this.before = before;
        this.first = first;
        this.last = last;
        this.offset = offset;
    }


    public static PageableRequest first(Integer first) {
        return PageableRequest.of(null, null, first, null, null);
    }

    public static PageableRequest last(Integer last) {
        return PageableRequest.of(null, null, null, last, null);
    }

    public static PageableRequest cursorBasedFirst(Cursor after, Cursor before, Integer first) {
        return PageableRequest.of(after, before,  first, null, null);
    }

    public static PageableRequest cursorBasedLast(Cursor after, Cursor before, Integer last) {
        return PageableRequest.of(after, before, null, last, null);
    }

    public static PageableRequest offsetBasedFirst(Integer offset, Integer last) {
        return PageableRequest.of(null, null, null, last, offset);
    }

    public static PageableRequest ofCursorBased(Cursor after, Cursor before, Integer first, Integer last) {
        return PageableRequest.of(after, before, first, last, null);
    }
    public static PageableRequest ofOffsetBased(Integer offset, Integer first) {
        return PageableRequest.of(null, null, first, null, offset);
    }

    public static PageableRequest after(@Nullable Cursor after, int first) {
        return PageableRequest.of(after, null, first, null, null);
    }

    public static PageableRequest of(Cursor after, Cursor before, Integer first, Integer last, Integer offset) {
        return new PageableRequest(after, before, first, last, offset, Sort.unsorted());
    }
    public static PageableRequest of(Cursor after, Cursor before, Integer first, Integer last, Integer offset, Sort sort) {
        return new PageableRequest(after, before, first, last, offset, sort);
    }


    public static PageableRequest of(Pageable pageable, Sort sort) {
        return PageableRequest.of(pageable.getAfter(), pageable.getBefore(), pageable.getFirst(), pageable.getLast(), pageable.getOffset(), sort);
    }

    public static PageableRequest empty() {
        return PageableRequest.of(null, null, null, null, null, null);
    }


    public Integer getFirst() {
        return first;
    }
    public Optional<Integer> getFirstOptional() {
        return Optional.ofNullable(first);
    }

    public Integer getLast() {
        return last;
    }

    public Optional<Integer> getLastOptional() {
        return Optional.ofNullable(last);
    }

    public Cursor getAfter() {
        return after;
    }

    public Optional<Cursor> getAfterOptional() {
        return Optional.ofNullable(after);
    }

    public Cursor getBefore() {
        return before;
    }
    public Optional<Cursor> getBeforeOptional() {
        return Optional.ofNullable(before);
    }
    public Integer getOffset() {
        return offset;
    }
    public Optional<Integer> getOffsetOptional() {
        return Optional.ofNullable(offset);
    }

    public Sort getSort() {
        return sort;
    }

    @Override
    public Pageable withSort(Sort sort) {
        return PageableRequest.of(this, sort);
    }
}
