package org.beast.data.converter;

import org.beast.data.relay.Cursor;
import org.beast.data.relay.SimpleCursor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.lang.NonNull;

import java.util.ArrayList;
import java.util.List;

public class CursorConverters {

    public static List<?> getConvertersToRegister() {
        List<Object> converters = new ArrayList<>();
        converters.add(StringToCursorConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public enum StringToCursorConverter implements Converter<String, Cursor> {
        INSTANCE;

        @Override
        public Cursor convert(@NonNull String source) {
            return SimpleCursor.valueOf(source);
        }
    }

    @WritingConverter
    public enum CursorToStringConverter implements Converter<Cursor, String> {
        INSTANCE;

        @Override
        public String convert(@NonNull Cursor source) {
            return source.getValue();
        }
    }
}
