/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.util;

import com.google.common.base.Strings;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class IPMatcher {
    public static boolean some(String ip, Collection<String> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            throw new IllegalArgumentException("rules not is empty");
        }
        for (String rule : rules) {
            if (!IPMatcher.match(ip, rule)) continue;
            return true;
        }
        return false;
    }

    public static boolean every(String ip, Collection<String> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            throw new IllegalArgumentException("rules not is empty");
        }
        for (String rule : rules) {
            if (IPMatcher.match(ip, rule)) continue;
            return false;
        }
        return true;
    }

    public static boolean match(String ip, String rule) {
        if (Strings.isNullOrEmpty((String)ip) || Strings.isNullOrEmpty((String)rule)) {
            throw new IllegalArgumentException("invalid match ip:" + ip + " rule:" + rule);
        }
        String[] ipItems = ip.split("\\.");
        String[] ruleItems = rule.split("\\.");
        if (ipItems.length != 4 || ruleItems.length != 4) {
            throw new IllegalArgumentException("invalid match ip:" + ip + " rule:" + rule);
        }
        for (int i = 0; i < 4; ++i) {
            if ("*".equals(ruleItems[i]) || ruleItems[i].equals(ipItems[i])) continue;
            return false;
        }
        return true;
    }
}

