/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.ua;

import java.util.regex.Pattern;

public enum ClientAgent {
    WEAPP(Pattern.compile(".*\\bminiProgram.*", 2)),
    WECHAT_DEVTOOLS(Pattern.compile(".*\\bwechatdevtools\\b.*", 2)),
    BYTEAPP(Pattern.compile(".*\\btoutiaomicroapp\\b.*", 2)),
    WEB(Pattern.compile(".*web.*", 2)),
    UNKNOWN(Pattern.compile(".*"));

    final Pattern pattern;

    private ClientAgent(Pattern pattern) {
        this.pattern = pattern;
    }

    public static ClientAgent valueOfString(String string) {
        try {
            return ClientAgent.valueOf(string);
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }

    public static ClientAgent parseUserAgent(String userAgent) {
        if (ClientAgent.WECHAT_DEVTOOLS.pattern.matcher(userAgent).matches()) {
            return WECHAT_DEVTOOLS;
        }
        if (ClientAgent.WEAPP.pattern.matcher(userAgent).matches()) {
            return WEAPP;
        }
        if (ClientAgent.BYTEAPP.pattern.matcher(userAgent).matches()) {
            return BYTEAPP;
        }
        if (ClientAgent.WEB.pattern.matcher(userAgent).matches()) {
            return WEB;
        }
        return UNKNOWN;
    }
}

