/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.util;

import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneDayIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(OneDayIdGenerator.class);
    private static final long TIMESTAMP_BIT = 26L;
    private static final long DATA_CENTER_BIT = 5L;
    private static final long WORKER_BIT = 5L;
    private static final long SEQUENCE_BIT = 10L;
    private static final long TIMESTAMP_MASK = 0x3FFFFFFL;
    private static final long DATA_CENTER_MASK = 31L;
    private static final long WORKER_MASK = 31L;
    private static final long SEQUENCE_MASK = 1023L;
    private static final long TIMESTAMP_SHIFT = 20L;
    private static final long DATA_CENTER_SHIFT = 15L;
    private static final long WORKER_SHIFT = 10L;
    private long lastTime = -1L;
    private long dataCenterId;
    private long workerId;
    private long sequence = 0L;

    public OneDayIdGenerator(long dataCenterId, long workerId) {
        this.dataCenterId = dataCenterId;
        this.workerId = workerId;
    }

    protected long time() {
        return System.currentTimeMillis();
    }

    protected long nextTime() {
        long timestamp = this.time();
        while (timestamp <= this.lastTime) {
            timestamp = this.time();
        }
        return timestamp;
    }

    private synchronized long nextIncId() {
        long now = this.time();
        if (now < this.lastTime) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (now == this.lastTime) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                now = this.nextTime();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTime = now;
        long time = now % 86400000L;
        return time << 20 | this.dataCenterId << 15 | this.workerId << 10 | this.sequence;
    }

    public synchronized String nextId() {
        long nextId = this.nextIncId();
        int id = Hashing.murmur3_32().hashLong(nextId).asInt();
        if (id < 0) {
            id = -id;
        }
        return Strings.padStart((String)String.valueOf(id %= 1000000000), (int)9, (char)'0');
    }
}

