/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.util;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectIdGenerator {
    private static final char[] HEX_UNIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long SYSTEM_START_TIME = 1646064000L;
    private final AtomicInteger sequenceCounter;
    private final char[] machineCode;
    public static final ObjectIdGenerator INSTANCE = new ObjectIdGenerator(ThreadLocalRandom.current().nextInt(), ObjectIdGenerator.initMachineCode());

    public ObjectIdGenerator(int sequence, char[] machineCode) {
        this.sequenceCounter = new AtomicInteger(sequence);
        this.machineCode = machineCode;
    }

    public String next() {
        char[] ids = new char[24];
        int epoch = (int)(System.currentTimeMillis() / 1000L - 1646064000L);
        for (int i = 7; i >= 0; --i) {
            ids[i] = HEX_UNIT[epoch & 0xF];
            epoch >>>= 4;
        }
        System.arraycopy(this.machineCode, 0, ids, 8, 10);
        int seq = this.sequenceCounter.incrementAndGet();
        for (int i = 23; i >= 18; --i) {
            ids[i] = HEX_UNIT[seq & 0xF];
            seq >>>= 4;
        }
        return new String(ids);
    }

    private static char[] initMachineCode() {
        char[] macAndPid = new char[10];
        Random random = new Random();
        for (int i = 9; i >= 0; --i) {
            macAndPid[i] = HEX_UNIT[random.nextInt() & 0xF];
        }
        return macAndPid;
    }
}

