package org.beast.data.util;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectIdGenerator {

    private static final char[] HEX_UNIT = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    /**
     * 系统起始时间(1646064000 : 2022-03-01 00:00:00 )，算法有效期： 138年。
     */
    private final static long SYSTEM_START_TIME = 1646064000L;
    /**
     * 计数器，自增id
     */
    private final AtomicInteger sequenceCounter;
    private final char[] machineCode;

    public static final ObjectIdGenerator INSTANCE = new ObjectIdGenerator(
            ThreadLocalRandom.current().nextInt(),
            initMachineCode()
    );

    public ObjectIdGenerator(int sequence, char[] machineCode) {
        this.sequenceCounter = new AtomicInteger(sequence);
        this.machineCode = machineCode;
    }

    /**
     * 生成一个递增的id
     */
    public String next() {
        char[] ids = new char[24];
        int epoch = (int) ((System.currentTimeMillis() / 1000) - SYSTEM_START_TIME);
        // 4位字节 ： 时间戳
        for (int i = 7; i >= 0; i--) {
            ids[i] = HEX_UNIT[(epoch & 15)];
            epoch >>>= 4;
        }
        // 5位字节 ： 随机数
        System.arraycopy(machineCode, 0, ids, 8, 10);
        // 3位字节： 自增序列。溢出后，相当于从0开始算。
        int seq = sequenceCounter.incrementAndGet();
        for (int i = 23; i >= 18; i--) {
            ids[i] = HEX_UNIT[(seq & 15)];
            seq >>>= 4;
        }
        return new String(ids);
    }

    private static char[] initMachineCode() {
        char[] macAndPid = new char[10];
        Random random = new Random();
        for (int i = 9; i >= 0; i--) {
            macAndPid[i] = HEX_UNIT[random.nextInt() & 15];
        }
        return macAndPid;
    }
}

