package org.beast.data.openfeign.support;

import feign.QueryMapEncoder;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.cloud.openfeign.support.AbstractFormWriter;
import org.springframework.cloud.openfeign.support.FeignEncoderProperties;
import org.springframework.cloud.openfeign.support.HttpMessageConverterCustomizer;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
public class BeastClientsConfiguration  {

    @Autowired
    private ObjectFactory<HttpMessageConverters> messageConverters;

    @Autowired(required = false)
    private FeignEncoderProperties encoderProperties;
//    @Bean
//    @ConditionalOnMissingBean
//    public QueryMapEncoder beastQueryMapEncoderPageable() {
//        return new PageableSpringQueryMapEncoder();
//    }

    private Encoder springEncoder(FeignEncoderProperties encoderProperties, ObjectProvider<HttpMessageConverterCustomizer> customizers) {
        return new SpringEncoder(new SpringFormEncoder(), messageConverters, encoderProperties, customizers);
    }
    @Bean
    public Encoder beastEncoderPageable(ObjectProvider<AbstractFormWriter> formWriterProvider,
                                        ObjectProvider<HttpMessageConverterCustomizer> customizers) {
        org.springframework.cloud.openfeign.support.PageableSpringEncoder encoder = new org.springframework.cloud.openfeign.support.PageableSpringEncoder(
                springEncoder(encoderProperties, customizers));
        return new PageableSpringEncoder(encoder);
    }

}
