/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.relay;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.beast.data.relay.Cursor;
import org.springframework.lang.Nullable;

public class SimpleCursor
implements Cursor {
    private final List<String> cursors;

    protected SimpleCursor(List<String> cursors) {
        this.cursors = cursors;
    }

    public static SimpleCursor valueOf(String rawValue) {
        return new SimpleCursor(SimpleCursor.decode(rawValue));
    }

    public static SimpleCursor valueOfCursors(List<String> cursors) {
        return new SimpleCursor(cursors);
    }

    public int size() {
        return this.cursors.size();
    }

    public String getValue(int index) {
        return this.cursors.get(index);
    }

    public static List<String> decode(String value) {
        ArrayList<String> values = new ArrayList<String>();
        Base64.Decoder decoder = Base64.getDecoder();
        for (String encodeValue : Splitter.on((String)".").split((CharSequence)value)) {
            values.add(new String(decoder.decode(encodeValue), StandardCharsets.UTF_8));
        }
        return values;
    }

    public static String encode(List<String> indexes) {
        ArrayList<String> encodeValues = new ArrayList<String>();
        for (String value : indexes) {
            if (Objects.isNull(value)) {
                value = "";
            }
            String encodedValue = Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
            encodeValues.add(encodedValue);
        }
        return Joiner.on((String)".").join(encodeValues);
    }

    @Nullable
    @JsonCreator
    public static SimpleCursor ofNullable(String rawValue) {
        if (Objects.isNull(rawValue)) {
            return null;
        }
        return SimpleCursor.valueOf(rawValue);
    }

    @Override
    @JsonValue
    public String getValue() {
        return SimpleCursor.encode(this.cursors);
    }

    public String toString() {
        return this.getValue();
    }
}

