package org.beast.data.message;

/**
 * 错误持有者
 * - 通过code, args 结合MessageSource 生成一个ErrorInfo
 */
public interface MessageErrorOwner {

    String getErrorCode();

    default Return<?> toReturn() {
        return toReturn(new Object[]{});
    }

    default Return<?> toReturn(Object... args) {
        return Returns.error(toError(args));
    };

    default MessageError toError() {
        return toError(new Object[]{});
    }

    default MessageError toError(Object... args) {
        return new MessageError(this.getErrorCode(), args);
    }

    default ErrorException toException() {
        return toException(new Object[]{});
    }

    default ErrorException toException(Object... args) {
        return new ErrorException(toError(args));
    }

}
