package org.beast.data.domain;

import lombok.Data;
import org.springframework.lang.NonNull;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@Data
public class PageResult<T>  {

    private List<T> rows = Collections.emptyList();


    private long total;

    public PageResult() {
    }

    public PageResult(List<T> rows, long total) {
        this.rows = rows;
        this.total = total;
    }


    @NonNull
    public <U> PageResult<U> map(@NonNull Function<? super T, ? extends U> converter) {
        return new PageResult<>(
                rows.stream().map(converter).collect(Collectors.toList()),
                total
        );
    }

    public Iterator<T> iterator() {
        return this.rows.iterator();
    }
}
