package org.beast.data.relay;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.Getter;

import java.util.function.Function;

@Getter
public class SimpleEdge<T> implements Edge<T>{

    private T node;

    private Cursor cursor;

    public SimpleEdge(@JsonProperty("node") T node,
                      @JsonProperty("cursor") Cursor cursor) {
        this.node = node;
        this.cursor = cursor;
    }


    @Override
    public <O> Edge<O> map(Function<T, O> mapper) {
        return new SimpleEdge<O>(mapper.apply(node), cursor);
    }
}
