package org.beast.data.querydsl;


import com.querydsl.core.types.Predicate;
import org.beast.data.relay.Connection;
import org.beast.data.relay.Cursor;
import org.beast.data.relay.Edge;
import org.beast.data.relay.Pageable;
import org.springframework.data.domain.Sort;

import java.util.List;

public interface RelayQuerydslPredicateExecutor<T> {

    Iterable<T> findAll(Predicate predicate, Pageable pageable);

    List<Edge<T>> findAllEdge(Predicate predicate, Pageable pageable);

    Edge<T> findFirstEdge(Predicate predicate, Sort sort);

    Edge<T> findLastEdge(Predicate predicate, Sort sort);

    boolean hasPrevious(Cursor cursor, Predicate predicate, Sort sort);

    boolean hasNext(Cursor cursor, Predicate predicate, Sort sort);

    Connection<T> connect(Predicate predicate, Pageable pageable);
}
