/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.openfeign.support;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.beast.data.relay.Pageable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;

public class PageableSpringEncoder
implements Encoder {
    private static final Logger log = LoggerFactory.getLogger(PageableSpringEncoder.class);
    private final Encoder delegate;
    private String beforeParameter = "before";
    private String afterParameter = "after";
    private String firstParameter = "first";
    private String sortParameter = "sort";
    private String offsetParameter = "offset";

    public PageableSpringEncoder(Encoder delegate) {
        this.delegate = delegate;
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        if (this.supports(object)) {
            Pageable pageable = (Pageable)object;
            this.query(template, this.firstParameter, pageable.getFirst());
            this.query(template, this.beforeParameter, pageable.getBefore());
            this.query(template, this.afterParameter, pageable.getAfter());
            this.query(template, this.offsetParameter, pageable.getOffset());
            if (Objects.nonNull(pageable.getSort())) {
                this.applySort(template, pageable.getSort());
            }
        } else if (this.delegate != null) {
            this.delegate.encode(object, bodyType, template);
        }
    }

    private void query(RequestTemplate template, String name, Object value) {
        if (Objects.nonNull(value)) {
            String encodedValue = String.valueOf(value);
            template.query(name, new String[]{encodedValue});
        }
    }

    private void applySort(RequestTemplate template, Sort sort) {
        ArrayList<CallSite> sortQueries;
        Collection existingSorts = (Collection)template.queries().get("sort");
        ArrayList<CallSite> arrayList = sortQueries = existingSorts != null ? new ArrayList<CallSite>(existingSorts) : new ArrayList();
        if (!this.sortParameter.equals("sort") && (existingSorts = (Collection)template.queries().get(this.sortParameter)) != null) {
            sortQueries.addAll(existingSorts);
        }
        for (Sort.Order order : sort) {
            sortQueries.add((CallSite)((Object)(order.getProperty() + "%2C" + order.getDirection())));
        }
        if (!sortQueries.isEmpty()) {
            template.query(this.sortParameter, sortQueries);
        }
    }

    protected boolean supports(Object object) {
        return object instanceof Pageable;
    }
}

