/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.web;

import java.util.Optional;
import org.beast.data.relay.Cursor;
import org.beast.data.relay.Pageable;
import org.beast.data.relay.PageableRequest;
import org.beast.data.web.PageableDefault;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class PageableHandlerMethodArgumentResolverSupport {
    private static final String DEFAULT_FIRST_PARAMETER = "first";
    private static final String DEFAULT_OFFSET_PARAMETER = "offset";
    private static final String DEFAULT_SORT_PARAMETER = "sort";
    private static final String DEFAULT_DIRECTION_PARAMETER = "direction";
    private Pageable fallbackPageable = PageableRequest.of(null, null, 10, null, 0);
    private boolean oneIndexedParameters = false;
    protected int maxOffset = 200000;

    protected Pageable getPageable(MethodParameter methodParameter, @Nullable Cursor after, @Nullable Cursor before, @Nullable Integer first, @Nullable Integer offset) {
        Optional<Pageable> defaultOrFallback = Optional.ofNullable(this.getDefaultFromAnnotationOrFallback(methodParameter));
        first = Optional.ofNullable(first).orElseGet(() -> defaultOrFallback.map(Pageable::getFirst).orElseThrow());
        offset = Optional.ofNullable(offset).orElseGet(() -> defaultOrFallback.map(Pageable::getOffset).orElseThrow());
        return PageableRequest.of(after, before, first, null, offset, defaultOrFallback.map(Pageable::getSort).orElseGet(Sort::unsorted));
    }

    private Optional<Integer> parseAndApplyBoundaries(@Nullable String parameter, int upper, boolean shiftIndex) {
        if (!StringUtils.hasText((String)parameter)) {
            return Optional.empty();
        }
        try {
            int parsed = Integer.parseInt(parameter) - (this.oneIndexedParameters && shiftIndex ? 1 : 0);
            return Optional.of(parsed < 0 ? 0 : (parsed > upper ? upper : parsed));
        }
        catch (NumberFormatException e) {
            return Optional.of(0);
        }
    }

    private Pageable getDefaultFromAnnotationOrFallback(MethodParameter methodParameter) {
        PageableDefault defaults = (PageableDefault)methodParameter.getParameterAnnotation(PageableDefault.class);
        if (defaults != null) {
            return PageableHandlerMethodArgumentResolverSupport.getDefaultPageRequestFrom(methodParameter, defaults);
        }
        return this.fallbackPageable;
    }

    private static Pageable getDefaultPageRequestFrom(MethodParameter parameter, PageableDefault defaults) {
        int first = defaults.first();
        int offset = defaults.offset();
        Sort sort = Sort.by((Sort.Direction)defaults.direction(), (String[])defaults.sort());
        return PageableRequest.of(null, null, first, null, offset, sort);
    }
}

