/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.converter;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;

public class TimeConverters {
    public static List<?> getConvertersToRegister() {
        ArrayList<StringToInstantConverter> converters = new ArrayList<StringToInstantConverter>();
        converters.add(StringToInstantConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public static enum StringToInstantConverter implements Converter<String, Instant>
    {
        INSTANCE;


        public Instant convert(@NonNull String source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            try {
                long value = Long.parseLong(source);
                return Instant.ofEpochMilli(value);
            }
            catch (NumberFormatException numberFormatException) {
                return Instant.parse(source);
            }
        }
    }
}

