package org.beast.data.web.config;

import org.beast.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.util.Lazy;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;

@Configuration(proxyBeanMethods = false)
public class BeastDataWebConfiguration implements WebMvcConfigurer {

    private final Lazy<SortHandlerMethodArgumentResolver> sortResolver;
    private final Lazy<PageableHandlerMethodArgumentResolver> pageableResolver;

    public BeastDataWebConfiguration(ApplicationContext context,
                                      @Qualifier("mvcConversionService") ObjectFactory<ConversionService> conversionService) {
        this.sortResolver = Lazy.of(() -> context.getBean("sortResolver", SortHandlerMethodArgumentResolver.class));
        this.pageableResolver = Lazy.of(() -> context.getBean("relayPageableResolver", PageableHandlerMethodArgumentResolver.class));
    }
    @Bean
    public PageableHandlerMethodArgumentResolver relayPageableResolver() {

        PageableHandlerMethodArgumentResolver pageableResolver = //
                new PageableHandlerMethodArgumentResolver(sortResolver.get());
//        customizePageableResolver(pageableResolver);
        return pageableResolver;
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(sortResolver.get());
        resolvers.add(pageableResolver.get());
    }
}
