package org.beast.data.relay;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.Lists;
import org.springframework.data.util.Streamable;

import java.util.*;

/**
 * IndexCursor
 */
public class RawCursor implements Streamable<Object> {

    //createdAt,id
    //如createdAt:desc, id:asc, 先按createAt排序 如有重复值按id排序
    private final List<Object> rawValues;

    public RawCursor(List<Object> rawValues) {
        this.rawValues = rawValues;
    }

    public RawCursor(Object ...rawValues) {
         this(Lists.newArrayList(rawValues));
    }

//    public IndexCursor(String value) {
//        this.indexes = decode(value);
//    }

//    @JsonCreator
//    public static OrdersCursor ofNullable(String rawValue) {
//        if (rawValue == null) {
//            return null;
//        }
//        return new OrdersCursor(rawValue);
//    }

    @JsonCreator
    public static RawCursor ofNullable(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        return new RawCursor(rawValue);
    }


    public int size() {
        return this.rawValues.size();
    }

    public Object getRawValue(int index) {
        return this.rawValues.get(index);
    }
//    @Override
//    public int compareTo(@NonNull IndexCursor o) {
//        this.indexes
//        return getValue().com(o.getValue());
//    }
//
//    public Object getIndexFor(int index) {
//        return indexes.get(index);
//    }

    @Override
    public Iterator<Object> iterator() {
        return this.rawValues.iterator();
    }


//    @Override
//    public Object getValue() {
//        return encode(this.indexes);
//    }
//
//    @JsonValue
//    @Override
//    public String toString() {
//        return this.getValue();
//    }


}
