package org.beast.data.relay;


import lombok.Data;
import lombok.Getter;

@Data
public class DefaultPageInfo implements PageInfo {

    private Cursor startCursor;
    private Cursor endCursor;
    private Boolean hasPreviousPage;
    private Boolean hasNextPage;

    public DefaultPageInfo() {
    }

    public DefaultPageInfo(Cursor startCursor, Cursor endCursor, Boolean hasPreviousPage, Boolean hasNextPage) {
        this.startCursor = startCursor;
        this.endCursor = endCursor;
        this.hasPreviousPage = hasPreviousPage;
        this.hasNextPage = hasNextPage;
    }

    @Override
    public boolean isHasPreviousPage() {
        return hasPreviousPage;
    }

    @Override
    public boolean isHasNextPage() {
        return hasNextPage;
    }
}
