package org.beast.data.relay;

import lombok.Data;

import java.util.Optional;
import java.util.function.Function;

@Data
public class DefaultEdge<T> implements Edge<T>{

    private T node;

    private Cursor cursor;

    public DefaultEdge() {
    }

    public DefaultEdge(T node, Cursor cursor) {
        this.node = node;
        this.cursor = cursor;
    }


    @Override
    public <O> Edge<O> map(Function<T, O> mapper) {
        return new DefaultEdge<O>(mapper.apply(node), cursor);
    }
}
