package org.beast.data.relay;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import org.springframework.lang.Nullable;

import java.nio.charset.StandardCharsets;
import java.util.*;

public class DefaultCursor implements Cursor {

    private final List<String> cursors;



    protected DefaultCursor(List<String> cursors) {
        this.cursors = cursors;
    }


    public static DefaultCursor valueOf(String rawValue) {
        return new DefaultCursor(decode(rawValue));
    }
    public static DefaultCursor valueOfCursors(List<String> cursors) {
        return new DefaultCursor(cursors);
    }


    public int size() {
        return cursors.size();
    }


    public String getValue(int index) {
        return this.cursors.get(index);
    }



    public static List<String> decode(String value) {
        List<String> values = new ArrayList<>();
        Base64.Decoder decoder = Base64.getDecoder();
        for (String encodeValue : Splitter.on(".").split(value)) {
            values.add(new String(decoder.decode(encodeValue), StandardCharsets.UTF_8));
        }
        return values;
    }

    public static String encode(List<String> indexes) {
        List<String> encodeValues = new ArrayList<>();
        for (String value : indexes) {
            if (Objects.isNull(value)) {
                value = "";
            }
            String encodedValue = Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
            encodeValues.add(encodedValue);

        }
        return Joiner.on(".").join(encodeValues);
    }


    @Nullable
    @JsonCreator
    public static DefaultCursor ofNullable(String rawValue) {
        if (Objects.isNull(rawValue)) {
            return null;
        }
        return valueOf(rawValue);
    }

    @JsonValue
    @Override
    public String getValue() {
        return encode(this.cursors);
    }

    @Override
    public String toString() {
        return getValue();
    }
}
