package org.beast.data.relay;

import lombok.Data;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@Data
public class DefaultConnection<T> implements Connection<T> {

    private List<Edge<T>> edges;

    private PageInfo pageInfo;

    private Long totalCount;

    public DefaultConnection() {
    }

    public DefaultConnection(List<Edge<T>> edges, PageInfo pageInfo, Long totalCount) {
        this.edges = edges;
        this.pageInfo = pageInfo;
        this.totalCount = totalCount;
    }


    @Override
    public <O> Connection<O> map(Function<T, O> mapper) {
        var output = this.edges.stream().map((edge) -> {
            return edge.map(mapper);
        }).toList();
        return new DefaultConnection<>(output, this.pageInfo, totalCount);
    }
}
