package org.beast.data.openfeign.support;

import feign.codec.EncodeException;
import feign.querymap.BeanQueryMapEncoder;
import org.beast.data.relay.Pageable;
import org.springframework.data.domain.Sort;

import java.util.*;

public class PageableSpringQueryMapEncoder extends BeanQueryMapEncoder {

    private String beforeParameter = "before";

    private String afterParameter = "after";

    private String firstParameter = "first";

    private String sortParameter = "sort";

    private String offsetParameter = "offset";

    @Override
    public Map<String, Object> encode(Object object) throws EncodeException {
        if (supports(object)) {
            Map<String, Object> queryMap = new HashMap<>();
            Pageable pageable = (Pageable) object;
            if (Objects.nonNull(pageable.getFirst())) {
                queryMap.put(firstParameter, pageable.getFirst());
            }
            if (Objects.nonNull(pageable.getBefore())) {
                queryMap.put(beforeParameter, pageable.getBefore());
            }
            if (Objects.nonNull(pageable.getAfter())) {
                queryMap.put(afterParameter, pageable.getAfter());
            }
            if (Objects.nonNull(pageable.getOffset())) {
                queryMap.put(offsetParameter, pageable.getOffset());
            }
            if (Objects.nonNull(pageable.getSort())) {
                applySort(queryMap, pageable.getSort());
            }

            return queryMap;
        } else {
            return super.encode(object);
        }
    }

    private void applySort(Map<String, Object> queryMap, Sort sort) {
        List<String> sortQueries = new ArrayList<>();
        for (Sort.Order order : sort) {
            sortQueries.add(order.getProperty() + "%2C" + order.getDirection());
        }
        if (!sortQueries.isEmpty()) {
            queryMap.put(sortParameter, sortQueries);
        }
    }

    protected boolean supports(Object object) {
        return object instanceof Pageable;
    }
}
