package org.beast.data.message;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

/**
 * 消息错误 - 结合message
 */
@ToString
@Getter
@Setter
public class MessageError implements IError {

    private String code;

    @Nullable
    private Object[] args;

    public MessageError(@NonNull String code) {
        this.code = code;
    }

    public MessageError(@NonNull String code, @Nullable Object[] args) {
        this.code = code;
        this.args = args;
    }

    public boolean is(String errorCode) {
        return this.code.equalsIgnoreCase(errorCode);
    }
}
