package org.beast.data.configuration;

import org.beast.data.util.CursorEncoder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

import java.util.Optional;

@Configuration(proxyBeanMethods = false)
public class BeastDataAutoConfiguration {


    @Bean
    public CursorEncoder cursorEncoder(
            @Qualifier("mvcConversionService") Optional<ConversionService> conversionServiceOptional
    ) {
        ConversionService conversionService = conversionServiceOptional.orElse(DefaultConversionService.getSharedInstance());
        return new CursorEncoder(conversionService);
    }
}
