/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.relay;

import java.util.List;
import java.util.function.Function;
import org.beast.data.relay.Connection;
import org.beast.data.relay.Edge;
import org.beast.data.relay.PageInfo;

public class DefaultConnection<T>
implements Connection<T> {
    private List<Edge<T>> edges;
    private PageInfo pageInfo;
    private Long totalCount;

    public DefaultConnection() {
    }

    public DefaultConnection(List<Edge<T>> edges, PageInfo pageInfo, Long totalCount) {
        this.edges = edges;
        this.pageInfo = pageInfo;
        this.totalCount = totalCount;
    }

    @Override
    public <O> Connection<O> map(Function<T, O> mapper) {
        List<Edge<T>> output = this.edges.stream().map((? super T edge) -> edge.map(mapper)).toList();
        return new DefaultConnection<T>(output, this.pageInfo, this.totalCount);
    }

    @Override
    public List<Edge<T>> getEdges() {
        return this.edges;
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    @Override
    public Long getTotalCount() {
        return this.totalCount;
    }

    public void setEdges(List<Edge<T>> edges) {
        this.edges = edges;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultConnection)) {
            return false;
        }
        DefaultConnection other = (DefaultConnection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        List<Edge<T>> this$edges = this.getEdges();
        List<Edge<T>> other$edges = other.getEdges();
        if (this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges)) {
            return false;
        }
        PageInfo this$pageInfo = this.getPageInfo();
        PageInfo other$pageInfo = other.getPageInfo();
        return !(this$pageInfo == null ? other$pageInfo != null : !this$pageInfo.equals(other$pageInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultConnection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        List<Edge<T>> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        PageInfo $pageInfo = this.getPageInfo();
        result = result * 59 + ($pageInfo == null ? 43 : $pageInfo.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultConnection(edges=" + this.getEdges() + ", pageInfo=" + this.getPageInfo() + ", totalCount=" + this.getTotalCount() + ")";
    }
}

