/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.function;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BeanFieldsCopyFunction<I, O> {
    protected final Class<O> entityClass;

    public BeanFieldsCopyFunction() {
        this(null);
    }

    public BeanFieldsCopyFunction(Class<O> clazz) {
        if (clazz == null) {
            Class<?> copyFunction = this.getClass();
            List arguments = ClassTypeInformation.from(copyFunction).getRequiredSuperTypeInformation(BeanFieldsCopyFunction.class).getTypeArguments();
            clazz = BeanFieldsCopyFunction.resolveTypeParameter(arguments, 1, () -> String.format("Could not resolve Output type of %s!", copyFunction));
        }
        this.entityClass = clazz;
    }

    private static Class<?> resolveTypeParameter(List<TypeInformation<?>> arguments, int index, Supplier<String> exceptionMessage) {
        if (arguments.size() <= index || arguments.get(index) == null) {
            throw new IllegalArgumentException(exceptionMessage.get());
        }
        return arguments.get(index).getType();
    }

    @NonNull
    private O newOutputInstance() {
        return (O)BeanUtils.instantiateClass(this.entityClass);
    }

    public Function<I, O> newFunction(String ... fields) {
        return this.newFunction(Arrays.asList(fields));
    }

    public Function<I, O> newFunction(final List<String> fields) {
        return new Function<I, O>(){

            @Override
            public O apply(I input) {
                Object output = BeanFieldsCopyFunction.this.newOutputInstance();
                Assert.notNull(output, (String)"BeanFieldsCopyFunction O Annotation require not null");
                BeanFieldsCopyFunction.copyProperties(input, output, fields);
                return output;
            }
        };
    }

    private static void copyProperties(Object source, Object target, List<String> fields) throws BeansException {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        for (PropertyDescriptor targetPd : targetPds = BeanUtils.getPropertyDescriptors(actualEditable)) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || fields != null && !fields.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }
}

