/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.web;

import java.util.Optional;
import org.beast.data.relay.DefaultCursor;
import org.beast.data.relay.Pageable;
import org.beast.data.web.PageableHandlerMethodArgumentResolverSupport;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageableHandlerMethodArgumentResolver
extends PageableHandlerMethodArgumentResolverSupport
implements HandlerMethodArgumentResolver {
    private SortArgumentResolver sortResolver;
    private static final int DEFAULT_MAX_PAGE_SIZE = 2000;
    private boolean oneIndexedParameters = false;

    public PageableHandlerMethodArgumentResolver(SortArgumentResolver sortResolver) {
        this.sortResolver = sortResolver;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return Pageable.class.equals((Object)parameter.getParameterType());
    }

    @Nullable
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        String after = webRequest.getParameter("after");
        String first = webRequest.getParameter("first");
        String offset = webRequest.getParameter("offset");
        Pageable pageable = this.getPageable(parameter, after, first, offset);
        Sort sort = this.sortResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        if (sort.isSorted()) {
            return pageable.withSort(sort);
        }
        return pageable;
    }

    private Pageable getPageable(MethodParameter parameter, String afterString, String firstString, String offsetString) {
        DefaultCursor after = DefaultCursor.ofNullable(afterString);
        Optional<Integer> first = this.parseAndApplyBoundaries(firstString, Integer.MAX_VALUE, true);
        Optional<Integer> offset = this.parseAndApplyBoundaries(offsetString, this.maxOffset, true);
        return this.getPageable(parameter, after, null, first.orElse(null), offset.orElse(null));
    }

    private Optional<Integer> parseAndApplyBoundaries(@Nullable String parameter, int upper, boolean shiftIndex) {
        if (!StringUtils.hasText((String)parameter)) {
            return Optional.empty();
        }
        try {
            int parsed = Integer.parseInt(parameter) - (this.oneIndexedParameters && shiftIndex ? 1 : 0);
            return Optional.of(parsed < 0 ? 0 : (parsed > upper ? upper : parsed));
        }
        catch (NumberFormatException e) {
            return Optional.of(0);
        }
    }
}

