/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.relay;

import java.util.Optional;
import org.beast.data.relay.Cursor;
import org.beast.data.relay.Pageable;
import org.springframework.data.domain.Sort;

public class PageableRequest
implements Pageable {
    private final Cursor after;
    private final Cursor before;
    private final Integer first;
    private final Integer last;
    private final Integer offset;
    private final Sort sort;

    private PageableRequest(Cursor after, Cursor before, Integer first, Integer last, Integer offset, Sort sort) {
        this.sort = sort;
        if (first != null && last != null) {
            throw new IllegalArgumentException("Passing both `first` and `last` to paginate connection is not supported.");
        }
        if (first != null && first < 0) {
            throw new IllegalArgumentException();
        }
        if (last != null && last < 0) {
            throw new IllegalArgumentException();
        }
        if (offset != null && last != null) {
            throw new IllegalArgumentException("Passing both `offset` and `last` to paginate connection is not supported.");
        }
        this.after = after;
        this.before = before;
        this.first = first;
        this.last = last;
        this.offset = offset;
    }

    public static PageableRequest first(Integer first) {
        return PageableRequest.of(null, null, first, null, null);
    }

    public static PageableRequest last(Integer last) {
        return PageableRequest.of(null, null, null, last, null);
    }

    public static PageableRequest cursorBasedFirst(Cursor after, Cursor before, Integer first) {
        return PageableRequest.of(after, before, first, null, null);
    }

    public static PageableRequest cursorBasedLast(Cursor after, Cursor before, Integer last) {
        return PageableRequest.of(after, before, null, last, null);
    }

    public static PageableRequest offsetBasedFirst(Integer offset, Integer last) {
        return PageableRequest.of(null, null, null, last, offset);
    }

    public static PageableRequest ofCursorBased(Cursor after, Cursor before, Integer first, Integer last) {
        return PageableRequest.of(after, before, first, last, null);
    }

    public static PageableRequest ofOffsetBased(Integer offset, Integer first) {
        return PageableRequest.of(null, null, first, null, offset);
    }

    public static PageableRequest of(Cursor after, Cursor before, Integer first, Integer last, Integer offset) {
        return new PageableRequest(after, before, first, last, offset, Sort.unsorted());
    }

    public static PageableRequest of(Cursor after, Cursor before, Integer first, Integer last, Integer offset, Sort sort) {
        return new PageableRequest(after, before, first, last, offset, sort);
    }

    public static PageableRequest of(Pageable pageable, Sort sort) {
        return PageableRequest.of(pageable.getAfter(), pageable.getBefore(), pageable.getFirst(), pageable.getLast(), pageable.getOffset(), sort);
    }

    public static PageableRequest empty() {
        return PageableRequest.of(null, null, null, null, null, null);
    }

    public PageableRequest with(Sort sort) {
        return PageableRequest.of(this, sort);
    }

    @Override
    public Integer getFirst() {
        return this.first;
    }

    public Optional<Integer> getFirstOptional() {
        return Optional.ofNullable(this.first);
    }

    @Override
    public Integer getLast() {
        return this.last;
    }

    public Optional<Integer> getLastOptional() {
        return Optional.ofNullable(this.last);
    }

    @Override
    public Cursor getAfter() {
        return this.after;
    }

    public Optional<Cursor> getAfterOptional() {
        return Optional.ofNullable(this.after);
    }

    @Override
    public Cursor getBefore() {
        return this.before;
    }

    public Optional<Cursor> getBeforeOptional() {
        return Optional.ofNullable(this.before);
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }

    public Optional<Integer> getOffsetOptional() {
        return Optional.ofNullable(this.offset);
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public Pageable withSort(Sort sort) {
        return PageableRequest.of(this, sort);
    }
}

