package org.beast.data.relay;


import lombok.Getter;

@Getter
public class DefaultPageInfo implements PageInfo {

    private final Cursor startCursor;
    private final Cursor endCursor;
    private final Boolean hasPreviousPage;
    private final Boolean hasNextPage;


    public DefaultPageInfo(Cursor startCursor, Cursor endCursor, Boolean hasPreviousPage, Boolean hasNextPage) {
        this.startCursor = startCursor;
        this.endCursor = endCursor;
        this.hasPreviousPage = hasPreviousPage;
        this.hasNextPage = hasNextPage;
    }

    @Override
    public boolean isHasPreviousPage() {
        return hasPreviousPage;
    }

    @Override
    public boolean isHasNextPage() {
        return hasNextPage;
    }
}
