package org.beast.data.relay;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;

import java.nio.charset.StandardCharsets;
import java.util.*;

public class ComposeCursor implements Cursor {

    private final List<String> cursors;



    protected ComposeCursor(List<String> cursors) {
        this.cursors = cursors;
    }


    public static ComposeCursor valueOf(String rawValue) {
        return new ComposeCursor(decode(rawValue));
    }
    public static ComposeCursor valueOfCursors(List<String> cursors) {
        return new ComposeCursor(cursors);
    }


    public int size() {
        return cursors.size();
    }


    public String getValue(int index) {
        return this.cursors.get(index);
    }



    public static List<String> decode(String value) {
        List<String> values = new ArrayList<>();
        Base64.Decoder decoder = Base64.getDecoder();
        for (String encodeValue : Splitter.on(".").split(value)) {
            values.add(new String(decoder.decode(encodeValue), StandardCharsets.UTF_8));
        }
        return values;
    }

    public static String encode(List<String> indexes) {
        List<String> encodeValues = new ArrayList<>();
        for (String value : indexes) {
            if (Objects.isNull(value)) {
                value = "";
            }
            String encodedValue = Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
            encodeValues.add(encodedValue);

        }
        return Joiner.on(".").join(encodeValues);
    }


    @Override
    public String getValue() {
        return encode(this.cursors);
    }
}
