package org.beast.data.domain;

import lombok.Data;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@Data
public class PageResult<T> implements Page<T> {

    private List<T> rows = Collections.emptyList();


    private long total;

    public PageResult() {
    }

    public PageResult(List<T> rows, long total) {
        this.rows = rows;
        this.total = total;
    }

    @Override
    public int getTotalPages() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTotalElements() {
        return this.total;
    }

    @Override
    public int getNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfElements() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    @Override
    public List<T> getContent() {
        return rows;
    }

    @Override
    public boolean hasContent() {
        return rows.size() > 0;
    }

    @NonNull
    @Override
    public Sort getSort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasPrevious() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    @Override
    public Pageable nextPageable() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    @Override
    public Pageable previousPageable() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    @Override
    public <U> Page<U> map(@NonNull Function<? super T, ? extends U> converter) {
        return new PageResult<>(
                rows.stream().map(converter).collect(Collectors.toList()),
                total
        );
    }

    @Override
    public Iterator<T> iterator() {
        return this.rows.iterator();
    }
}
