package org.beast.data.converter;

import org.beast.data.relay.RawCursor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.lang.NonNull;

import java.util.ArrayList;
import java.util.List;

public class CursorConverters {

    public static List<?> getConvertersToRegister() {
        List<Object> converters = new ArrayList<>();
        converters.add(StringToRawCursorConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public enum StringToRawCursorConverter implements Converter<String, RawCursor> {
        INSTANCE;

        @Override
        public RawCursor convert(@NonNull String source) {
            return new RawCursor(source);
        }
    }
}
