/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.domain;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Streamable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class ObjectCursor
implements Streamable<PropertyCursor>,
Serializable {
    private final List<PropertyCursor> cursors;

    public ObjectCursor(List<PropertyCursor> cursors) {
        this.cursors = cursors;
    }

    public ObjectCursor(PropertyCursor ... cursors) {
        this.cursors = List.of(cursors);
    }

    @NonNull
    public Iterator<PropertyCursor> iterator() {
        return this.cursors.iterator();
    }

    @Nullable
    public PropertyCursor getCursorFor(int index) {
        return this.cursors.get(index);
    }

    @Nullable
    public PropertyCursor getCursorFor(String property) {
        Iterator<PropertyCursor> iterator = this.iterator();
        while (iterator.hasNext()) {
            PropertyCursor cursor = iterator.next();
            if (!cursor.getProperty().equals(property)) continue;
            return cursor;
        }
        return null;
    }

    public static final class PropertyCursor {
        private String property;
        private Object rawValue;
        private Sort.Direction direction;

        public String getProperty() {
            return this.property;
        }

        public Object getRawValue() {
            return this.rawValue;
        }

        public Sort.Direction getDirection() {
            return this.direction;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setRawValue(Object rawValue) {
            this.rawValue = rawValue;
        }

        public void setDirection(Sort.Direction direction) {
            this.direction = direction;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyCursor)) {
                return false;
            }
            PropertyCursor other = (PropertyCursor)o;
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            Object this$rawValue = this.getRawValue();
            Object other$rawValue = other.getRawValue();
            if (this$rawValue == null ? other$rawValue != null : !this$rawValue.equals(other$rawValue)) {
                return false;
            }
            Sort.Direction this$direction = this.getDirection();
            Sort.Direction other$direction = other.getDirection();
            return !(this$direction == null ? other$direction != null : !this$direction.equals(other$direction));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            Object $rawValue = this.getRawValue();
            result = result * 59 + ($rawValue == null ? 43 : $rawValue.hashCode());
            Sort.Direction $direction = this.getDirection();
            result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
            return result;
        }

        public String toString() {
            return "ObjectCursor.PropertyCursor(property=" + this.getProperty() + ", rawValue=" + this.getRawValue() + ", direction=" + this.getDirection() + ")";
        }
    }
}

