/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.config;

import java.util.List;
import java.util.function.Supplier;
import org.beast.data.config.Configurable;
import org.springframework.beans.BeanUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class AbstractConfigurable<C>
implements Configurable<C> {
    private Class<C> configClass;

    protected AbstractConfigurable(Class<C> configClass) {
        this.configClass = configClass;
    }

    protected AbstractConfigurable() {
        Class<?> configurableImpl = this.getClass();
        List arguments = ClassTypeInformation.from(configurableImpl).getRequiredSuperTypeInformation(AbstractConfigurable.class).getTypeArguments();
        this.configClass = this.resolveTypeParameter(arguments, 0, () -> String.format("could not resolve domain type of %s!", configurableImpl));
    }

    private Class<C> resolveTypeParameter(List<TypeInformation<?>> arguments, int index, Supplier<String> exceptionMessage) {
        if (arguments.size() <= index || arguments.get(index) == null) {
            throw new IllegalArgumentException(exceptionMessage.get());
        }
        return arguments.get(index).getType();
    }

    @Override
    public Class<C> getConfigClass() {
        return this.configClass;
    }

    @Override
    public C newConfig() {
        return (C)BeanUtils.instantiateClass(this.configClass);
    }
}

