package org.beast.data.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import org.springframework.lang.NonNull;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;

/**
 * RawCursor
 */
public class RawCursor implements Cursor, Comparable<RawCursor>{

    private final List<String> values;

    public RawCursor(List<String> values) {
        this.values = values;
    }

    public RawCursor(String rawValue) {
        this.values = getOrdersFromRawValues(rawValue);
    }

//    @JsonCreator
//    public static OrdersCursor ofNullable(String rawValue) {
//        if (rawValue == null) {
//            return null;
//        }
//        return new OrdersCursor(rawValue);
//    }

    public List<String> getOrders() {
        return this.values;
    }

    @Override
    public int compareTo(@NonNull RawCursor o) {
        return getValue().compareTo(o.getValue());
    }



    @Override
    public String getValue() {
        return getRawValueFromOrders(this.values);
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public static List<String> getOrdersFromRawValues(String rawValue) {
        List<String> values = new ArrayList<>();
        Base64.Decoder decoder = Base64.getDecoder();
        for (String encodeValue : Splitter.on(".").split(rawValue)) {
            values.add(new String(decoder.decode(encodeValue), StandardCharsets.UTF_8));
        }
        return values;
    }

    public static String getRawValueFromOrders(List<String> orders) {
        List<String> encodeValues = new ArrayList<>();
        for (String value : orders) {
            if (Objects.isNull(value)) {
                value = "";
            }
            String encodedValue = Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
            encodeValues.add(encodedValue);

        }
        return Joiner.on(".").join(encodeValues);
    }
}
