package org.beast.data.domain;

import com.google.common.collect.Lists;
import org.springframework.data.util.Streamable;

import java.util.Iterator;
import java.util.List;

public class OrderCursor implements Streamable<Object> {

    private final List<Object> rawValues;


    public OrderCursor(Object ...rawValues) {
        this.rawValues = Lists.newArrayList(rawValues);
    }


    public static OrderCursor valueOf(Object ...rawValues) {
        return new OrderCursor(rawValues);
    }

    @Override
    public Iterator<Object> iterator() {
        return rawValues.iterator();
    }

    public int size() {
        return rawValues.size();
    }

    public Object getCursorFor(int index) {
        return rawValues.get(index);
    }
}
