/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.beast.data.domain.Cursor;
import org.springframework.lang.NonNull;

public class RawCursor
implements Cursor,
Comparable<RawCursor> {
    private final List<String> values;

    public RawCursor(List<String> values) {
        this.values = values;
    }

    public RawCursor(String rawValue) {
        this.values = RawCursor.getOrdersFromRawValues(rawValue);
    }

    public List<String> getOrders() {
        return this.values;
    }

    @Override
    public int compareTo(@NonNull RawCursor o) {
        return this.getValue().compareTo(o.getValue());
    }

    @Override
    public String getValue() {
        return RawCursor.getRawValueFromOrders(this.values);
    }

    public String toString() {
        return this.getValue();
    }

    public static List<String> getOrdersFromRawValues(String rawValue) {
        ArrayList<String> values = new ArrayList<String>();
        Base64.Decoder decoder = Base64.getDecoder();
        for (String encodeValue : Splitter.on((String)".").split((CharSequence)rawValue)) {
            values.add(new String(decoder.decode(encodeValue), StandardCharsets.UTF_8));
        }
        return values;
    }

    public static String getRawValueFromOrders(List<String> orders) {
        ArrayList<String> encodeValues = new ArrayList<String>();
        for (String value : orders) {
            if (Objects.isNull(value)) {
                value = "";
            }
            String encodedValue = Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
            encodeValues.add(encodedValue);
        }
        return Joiner.on((String)".").join(encodeValues);
    }
}

