package org.beast.data.util;


import com.google.common.base.Strings;

import java.util.regex.Pattern;

public class EmailUtils {

    public static final String VALIDATE_EXPR = "^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*$";

    private static final Pattern EMAIL_PATTERN = Pattern.compile(VALIDATE_EXPR);

    public static boolean validate(String email) {
        if (Strings.isNullOrEmpty(email)) {
            return false;
        }
        return EMAIL_PATTERN.matcher(email).find();
    }

    public static String cover(String email) {
        int splitIndex = email.indexOf("@");
        int start = Math.max(0, splitIndex - 4);
        return (start > 0 ? email.substring(0, start) : "") + "*".repeat(splitIndex - start) + email.substring(splitIndex);
    }
}
